package fr.asip.cps3.exemple.vues.composants;
import java.awt.Color;

import javax.swing.BorderFactory;
import javax.swing.JLabel;

/**
 * Classe modlisant la barre de statut de l'application
 * destin  contenir la description de la librairie utilise
 *
 */
public class BarreStatut extends JLabel {

	private static final long serialVersionUID = 6881566719191329526L;

	/**
	 * Constructeur sans argument
	 */
    public BarreStatut() {
        super();
        setBorder(BorderFactory.createLineBorder(Color.GRAY));
        setBackground(Color.WHITE);
    }	
	
	/**
	 * Constructeur  1 argument
	 * @param librairie Description de la librairie utilise
	 */
	public BarreStatut(String librairie) {
        super();
        setLibrairie(librairie);
        setBorder(BorderFactory.createLineBorder(Color.GRAY));
        setBackground(Color.WHITE);
    }
    
	/**
	 * 
	 * @param librairie
	 */
    public void setLibrairie(String librairie) {
        setText(" Librairie: "+librairie);       
    }
    
}
